/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.GameWindowCallbackIf;
import de.matthiasmann.twl.utils.PNGDecoder;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.UnicodeFont;
import org.newdawn.slick.font.effects.ColorEffect;
import org.newdawn.slick.font.effects.GradientEffect;
import org.newdawn.slick.font.effects.OutlineEffect;
import org.newdawn.slick.util.ResourceLoader;
import util.PathTools;
import util.ResourceManager;

public class GameWindow {
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_CENTER = 2;
    public static final int ALIGN_RIGHT = 3;
    private GameWindowCallbackIf callback;
    private boolean gameRunning = true;
    private int width;
    private int height;
    public static UnicodeFont FONT_MAIN = null;
    public static UnicodeFont FONT_TITLE = null;
    public static UnicodeFont FONT_SMALL = null;
    public static UnicodeFont FONT_MENU = null;
    public static UnicodeFont[] FONT_MAIN_DIFFICULTY;
    private int fps;
    private String title = null;

    public GameWindow() {
        System.setProperty("org.lwjgl.librarypath", PathTools.getNativeDirectory());
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    private void initFont() {
        try {
            InputStream inputStream = ResourceLoader.getResourceAsStream((String)"resources/fonts/JandaManateeSolid.ttf");
            Font mainFont = Font.createFont(0, inputStream);
            FONT_MAIN = new UnicodeFont(mainFont, 20, false, false);
            FONT_MAIN.getEffects().add(new ColorEffect(Color.white));
            FONT_MAIN.addAsciiGlyphs();
            FONT_MAIN.loadGlyphs();
            inputStream.close();
            FONT_MAIN_DIFFICULTY = new UnicodeFont[4];
            GameWindow.FONT_MAIN_DIFFICULTY[0] = new UnicodeFont(mainFont, 20, false, false);
            FONT_MAIN_DIFFICULTY[0].getEffects().add(new ColorEffect(new Color(255, 191, 0)));
            FONT_MAIN_DIFFICULTY[0].addAsciiGlyphs();
            FONT_MAIN_DIFFICULTY[0].loadGlyphs();
            GameWindow.FONT_MAIN_DIFFICULTY[1] = new UnicodeFont(mainFont, 20, false, false);
            FONT_MAIN_DIFFICULTY[1].getEffects().add(new ColorEffect(new Color(255, 128, 0)));
            FONT_MAIN_DIFFICULTY[1].addAsciiGlyphs();
            FONT_MAIN_DIFFICULTY[1].loadGlyphs();
            GameWindow.FONT_MAIN_DIFFICULTY[2] = new UnicodeFont(mainFont, 20, false, false);
            FONT_MAIN_DIFFICULTY[2].getEffects().add(new ColorEffect(new Color(255, 64, 0)));
            FONT_MAIN_DIFFICULTY[2].addAsciiGlyphs();
            FONT_MAIN_DIFFICULTY[2].loadGlyphs();
            GameWindow.FONT_MAIN_DIFFICULTY[3] = new UnicodeFont(mainFont, 20, false, false);
            FONT_MAIN_DIFFICULTY[3].getEffects().add(new ColorEffect(new Color(255, 0, 0)));
            FONT_MAIN_DIFFICULTY[3].addAsciiGlyphs();
            FONT_MAIN_DIFFICULTY[3].loadGlyphs();
            Font smallFont = new Font("Arial", 0, 12);
            FONT_SMALL = new UnicodeFont(smallFont, 12, false, false);
            FONT_SMALL.getEffects().add(new ColorEffect(Color.white));
            FONT_SMALL.addAsciiGlyphs();
            FONT_SMALL.loadGlyphs();
            inputStream = ResourceLoader.getResourceAsStream((String)"resources/fonts/kberry.ttf");
            Font titleFont = Font.createFont(0, inputStream);
            FONT_TITLE = new UnicodeFont(titleFont, 72, true, false);
            FONT_TITLE.getEffects().add(new ColorEffect(Color.white));
            FONT_TITLE.getEffects().add(new GradientEffect(Color.white, Color.black, 1.0f));
            FONT_TITLE.getEffects().add(new OutlineEffect(2, new Color(16, 16, 16)));
            FONT_TITLE.addAsciiGlyphs();
            FONT_TITLE.loadGlyphs();
            inputStream.close();
            inputStream = ResourceLoader.getResourceAsStream((String)"resources/fonts/Australian Sunset.ttf");
            Font menueFont = Font.createFont(0, inputStream);
            FONT_MENU = new UnicodeFont(menueFont, 24, false, false);
            FONT_MENU.getEffects().add(new ColorEffect(Color.white));
            FONT_MENU.addAsciiGlyphs();
            FONT_MENU.loadGlyphs();
            inputStream.close();
        }
        catch (FontFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SlickException e) {
            e.printStackTrace();
        }
    }

    public void drawText(UnicodeFont font, float x, float y, String text) {
        this.drawText(font, x, y, text, 1);
    }

    public void drawText(UnicodeFont font, float x, float y, String text, int align) {
        String[] lines = text.split("\n");
        int heightOffset = 0;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.equals("")) {
                heightOffset += font.getHeight("W");
            }
            switch (align) {
                case 1: {
                    font.drawString(x, y + (float)heightOffset, line);
                    break;
                }
                case 2: {
                    font.drawString(x - (float)(font.getWidth(line) / 2), y + (float)heightOffset, line);
                    break;
                }
                case 3: {
                    font.drawString(x - (float)font.getWidth(line), y + (float)heightOffset, line);
                }
            }
            heightOffset += font.getHeight(line);
            ++n2;
        }
    }

    public void setTitle() {
        this.setTitle(this.title);
    }

    public void setTitle(String title) {
        if (this.displayReady()) {
            Display.setTitle((String)title);
            this.title = null;
        } else {
            this.title = title;
        }
    }

    public boolean displayReady() {
        return Display.isCreated();
    }

    public void setResolution(int x, int y) {
        this.width = x;
        this.height = y;
    }

    public void setDisplayMode(int width, int height, boolean fullscreen) {
        if (Display.getDisplayMode().getWidth() == width && Display.getDisplayMode().getHeight() == height && Display.isFullscreen() == fullscreen) {
            return;
        }
        try {
            DisplayMode targetDisplayMode = null;
            if (fullscreen) {
                DisplayMode[] modes = Display.getAvailableDisplayModes();
                int freq = 0;
                int i = 0;
                while (i < modes.length) {
                    DisplayMode current = modes[i];
                    System.out.println(current.toString());
                    if (current.getWidth() == width && current.getHeight() == height) {
                        if (!(targetDisplayMode != null && current.getFrequency() < freq || targetDisplayMode != null && current.getBitsPerPixel() <= targetDisplayMode.getBitsPerPixel())) {
                            targetDisplayMode = current;
                            freq = targetDisplayMode.getFrequency();
                        }
                        if (current.getBitsPerPixel() == Display.getDesktopDisplayMode().getBitsPerPixel() && current.getFrequency() == Display.getDesktopDisplayMode().getFrequency()) {
                            targetDisplayMode = current;
                            break;
                        }
                    }
                    ++i;
                }
            } else {
                targetDisplayMode = new DisplayMode(width, height);
            }
            if (targetDisplayMode == null) {
                System.out.println("Failed to find value mode: " + width + "x" + height + " fs=" + fullscreen);
                return;
            }
            Display.setDisplayMode((DisplayMode)targetDisplayMode);
            Display.setFullscreen((boolean)fullscreen);
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
    }

    public void setIcons(String[] icons) {
        ByteBuffer[] bb = new ByteBuffer[icons.length];
        try {
            int i = 0;
            while (i < icons.length) {
                bb[i] = GameWindow.loadIcon(ResourceManager.get().getResource(icons[i]));
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Display.setIcon((ByteBuffer[])bb);
    }

    private static ByteBuffer loadIcon(URL url) throws IOException {
        InputStream is = url.openStream();
        try {
            PNGDecoder decoder = new PNGDecoder(is);
            ByteBuffer bb = ByteBuffer.allocateDirect(decoder.getWidth() * decoder.getHeight() * 4);
            decoder.decode(bb, decoder.getWidth() * 4, PNGDecoder.Format.RGBA);
            bb.flip();
            ByteBuffer byteBuffer = bb;
            return byteBuffer;
        }
        finally {
            is.close();
        }
    }

    public void setVsync(boolean vsync) {
        Display.setVSyncEnabled((boolean)vsync);
    }

    public void setFramerate(int fps) {
        this.fps = fps;
    }

    public void startRendering() {
        try {
            this.setDisplayMode(this.width, this.height, false);
            Display.setInitialBackground((float)0.0f, (float)0.0f, (float)0.0f);
            Display.create();
            this.setTitle();
            GL11.glEnable((int)3553);
            GL11.glShadeModel((int)7425);
            GL11.glDisable((int)2929);
            GL11.glDisable((int)2896);
            GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glClearDepth((double)1.0);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glViewport((int)0, (int)0, (int)this.width, (int)this.height);
            GL11.glMatrixMode((int)5888);
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            GL11.glOrtho((double)0.0, (double)this.width, (double)this.height, (double)0.0, (double)1.0, (double)-1.0);
            GL11.glMatrixMode((int)5888);
            this.initFont();
            if (this.callback != null) {
                this.callback.initialise();
            }
        }
        catch (LWJGLException e) {
            e.printStackTrace();
            this.setGameOver(true);
        }
        this.gameLoop();
    }

    public void setGameWindowCallback(GameWindowCallbackIf callback) {
        this.callback = callback;
    }

    public boolean isKeyPressed(int keyCode) {
        return Keyboard.isKeyDown((int)keyCode);
    }

    public void setGameOver(boolean gameOver) {
        this.gameRunning = !gameOver;
    }

    private void gameLoop() {
        while (this.gameRunning) {
            GL11.glClear((int)16640);
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            if (this.callback != null) {
                this.callback.frameRendering();
            }
            Display.update();
            Display.sync((int)this.fps);
            if (!Display.isCloseRequested()) continue;
            this.setGameOver(true);
        }
        this.callback.windowClosed();
    }

    public void cleanUp() {
        if (FONT_MAIN != null) {
            FONT_MAIN.destroy();
        }
        if (FONT_TITLE != null) {
            FONT_TITLE.destroy();
        }
        if (FONT_SMALL != null) {
            FONT_SMALL.destroy();
        }
        if (FONT_MENU != null) {
            FONT_MENU.destroy();
        }
        if (FONT_MAIN_DIFFICULTY != null) {
            UnicodeFont[] unicodeFontArray = FONT_MAIN_DIFFICULTY;
            int n = FONT_MAIN_DIFFICULTY.length;
            int n2 = 0;
            while (n2 < n) {
                UnicodeFont font = unicodeFontArray[n2];
                font.destroy();
                ++n2;
            }
        }
        Display.destroy();
    }
}

